# Generated by Django 2.2.26 on 2023-09-26 12:28

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("lava_scheduler_app", "0059_increase_remoteartifactsauth_token_max_length")
    ]

    operations = [
        migrations.RemoveIndex(
            model_name="testjob",
            name="current_job_prefetch_index",
        ),
        migrations.AlterField(
            model_name="groupdevicepermission",
            name="device",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="permissions",
                to="lava_scheduler_app.Device",
            ),
        ),
        migrations.AlterField(
            model_name="groupdevicetypepermission",
            name="devicetype",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="permissions",
                to="lava_scheduler_app.DeviceType",
            ),
        ),
        migrations.AlterField(
            model_name="groupworkerpermission",
            name="worker",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="permissions",
                to="lava_scheduler_app.Worker",
            ),
        ),
        migrations.AlterField(
            model_name="notificationrecipient",
            name="user",
            field=models.ForeignKey(
                blank=True,
                db_index=False,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
                verbose_name="Notification user recipient",
            ),
        ),
        migrations.AlterField(
            model_name="remoteartifactsauth",
            name="user",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
                verbose_name="User",
            ),
        ),
        migrations.AlterField(
            model_name="testjobuser",
            name="test_job",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to="lava_scheduler_app.TestJob",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="groupdevicepermission",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="groupdevicetypepermission",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="groupworkerpermission",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="notificationrecipient",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="remoteartifactsauth",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="testjobuser",
            unique_together=set(),
        ),
        migrations.AddConstraint(
            model_name="groupdevicepermission",
            constraint=models.UniqueConstraint(
                fields=("device", "permission", "group"),
                name="lava_scheduler_app_group_permission_device_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="groupdevicetypepermission",
            constraint=models.UniqueConstraint(
                fields=("devicetype", "permission", "group"),
                name="lava_scheduler_app_group_permission_devicetype_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="groupworkerpermission",
            constraint=models.UniqueConstraint(
                fields=("worker", "permission", "group"),
                name="lava_scheduler_app_group_permission_worker_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="notificationrecipient",
            constraint=models.UniqueConstraint(
                fields=("user", "notification", "method"),
                name="lava_scheduler_app_user_notification_method_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="remoteartifactsauth",
            constraint=models.UniqueConstraint(
                fields=("user", "name"),
                name="lava_scheduler_app_remote_artifact_user_and_name_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testjob",
            constraint=models.UniqueConstraint(
                condition=models.Q(
                    models.Q(_negated=True, state=5), ("actual_device__isnull", False)
                ),
                fields=("actual_device",),
                name="lava_scheduler_app_testjob_current_job_prefetch_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testjob",
            constraint=models.UniqueConstraint(
                condition=models.Q(_negated=True, sub_id=""),
                fields=("sub_id",),
                name="lava_scheduler_app_testjob_sub_id_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testjobuser",
            constraint=models.UniqueConstraint(
                fields=("test_job", "user"),
                name="lava_scheduler_app_test_job_user_uniq",
            ),
        ),
    ]
