#!/usr/bin/env python3

from setuptools import setup, find_packages

with open("requirements.txt") as f:
    lines = f.readlines()
    requirements = tuple(line.strip() for line in lines if line.strip())


setup(
    name='pcs-proxy',
    version='0.1',
    description='PCS Proxy',
    url='https://gitlab.collabora.com/collabora/pcs-proxy/',
    packages=find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3"
    ],
    entry_points={
        'console_scripts': [
            'pcs-proxy = pcs_proxy:main',
            'run_pcs_proxies = pcs_proxy.run_proxies:main'
        ]
    },
    scripts=['scripts/run_chronophage_proxy',
             'scripts/run_crm_proxy'],
    install_requires=requirements,
    zip_safe=False
)
