from multiprocessing import Process

from pcs_proxy import main as new_server


def main():
    processes = []
    for module in ("chronophage", "crm"):
        server = new_server(return_server=True, module=module)
        p = Process(target=server.serve_forever, args=tuple())
        p.start()
        processes.append(p)

    for p in processes:
        p.join()


if __name__ == "__main__":
    main()
