Reference: https://wiki.collabora.com/Delivery/Tools/pcs-proxy


# INSTALLATION

## Download

```
cd ~ 
git clone --recurse-submodules git@gitlab.collabora.com:collabora/pcs-proxy.git
cd ~/pcs-proxy
git submodule update --init --recursive
```

### Method 1: pipx (easier, faster and safe)

This method requires the system package `python-pipx` (or `python3-pipx`, or anything similar). [pipx](https://github.com/pypa/pipx) is a python library that automates the installation of Python applications in virtual environments (it also provides bindings to the `$PATH` variable)

- Install:
    ```
    pipx install .
    ```

- Update:
    ```
    git pull
    pipx install .
    ```
- Uninstall:
    ```
    pipx uninstall pcs_proxy
    ```


### Method 2: virtual environment (manual and safe)

This method requires the system package `python-virtualenv` (or `python3-virtualenv`, or anything similar):

- Install:
    ```
    python -m venv venv_pcs
    venv_pcs/bin/pip install pip setuptools --upgrade
    venv_pcs/bin/pip install .
    ln -s "$(pwd)/venv_pcs/bin/pcs-proxy" ~/.local/bin/pcs-proxy
    ln -s "$(pwd)/venv_pcs/bin/run_chronophage_proxy" ~/.local/bin/run_chronophage_proxy
    ln -s "$(pwd)/venv_pcs/bin/run_crm_proxy" ~/.local/bin/run_crm_proxy
    ln -s "$(pwd)/venv_pcs/bin/run_pcs_proxies" ~/.local/bin/run_pcs_proxies
    ```

- Update:
    ```
    git pull
    venv_pcs/bin/pip install .
    ```
- Uninstall:
    ```
    rm -rf venv_pcs
    rm -rf ~/.local/bin/pcs-proxy
    rm -rf ~/.local/bin/run_chronophage_proxy
    rm -rf ~/.local/bin/run_crm_proxy
    rm -rf ~/.local/bin/run_pcs_proxies
    ```

# USAGE:

Run one of the following commands below depending on need before using the macros in the PCS

```
run_pcs_proxies # run both Chronophage and CRM proxies together
run_chronophage_proxy
run_crm_proxy
```

## Target authentication
- PCS-Proxy will try to call a keyring client available from dbus (Gnome or KDE) to store the target application credentials (user/password)
- If no keyring client is installed the credentials should be supplied through the parameters `-u` (username) and `-p` (password)
 - Chronophage requires an API Key instead of user/password (it will be asked by the keyring client or it can be supplied through the parameter `a`)

# PRE-RELEASE MANUAL FUNCTIONAL TESTING:

The pcs proxy pulls data into the PCS from Chronophage (timesheet data and people information) and
pushes data to CRM from the PCS (actuals/forecast and PCS data). To functionally test pcs_proxy 
follow these steps:

1. Determine the tester(s):
    * Choose PM candidates with different linux distributions (Debian, Fedora, ...) to conduct the test, alternatively,
    * if the test is going to be conducted by a developer, please request from the Delivery Team to provide a test PCS as per point 2 below
2. Take a copy of a PCS from an active client project (should have actuals and forecast)
3. On the 'Parameters' tab, press the 'Update Employees/Contractors from Chronophage' button. 
Confirm that people table refreshes on that tab and no error message displayed by the macro.
3. Move to the 'Actuals' tab, select a week that has actuals (grey cells), select the date for the week (row 9)
and press the 'Update Forecast to Actuals for selected week' button. Confirm that the actuals imported remain
the same and no error message displayed by the macro.
4. Ensure the CRM pcs_proxy is connecting to the test instance of CRM
5. select the 'Health' tab and press the 'Push to CRM' button. Confirm that the PCS data (see 'PCS_to_CRM' tab for values pushed) has been updated against the PCS's
project in test.crm. There should be no errors displayed by the macro.
5. Now press the 'Push Actuals & Forecast' button on the 'Health' tab. Confirm that the actuals/forecast data has been pushed to CRM without any errors from the macro.
