<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE article PUBLIC "-//OASIS//DTD DocBook XML V4.1.2//EN"
    "http://www.oasis-open.org/docbook/xml/4.1.2/docbookx.dtd">

<?php
/**
   PCStoCRM.php
   Consolidated PCStoCRM server-side codebase
   to be installed alongside Chronophage software
   (c)2016 Collabora Ltd -- for internal use only

   PHP Version 5+

   @category Complete
   @package  PCStoCRM
   @author   Nick Milner <nick.milner@collabora.co.uk>
   @author   Quinn Ebert <quinn.ebert@collabora.co.uk>
   @license  internal http://www.collabora.co.uk/
   @link     http://www.collabora.co.uk/
*/

$url = "https://test.crm.collabora.com/service/v4_1/rest.php";

$username = $_GET["username"];
$password = $_GET["password"];

// This is an array of parameters which are NOT CRM fields and are needed
// for the scripts to run correctly. Any parameters *not* in this array
// will be written to the CRM record being updated
$special_params = array(
  'record_id',
  'proj_code',
  'username',
  'password',
  'debug',
  'submission_mode'
);

// Some common variables
$last_sunday = strtotime("last sunday");
$date_now = date('Y-m-d', time());

//login ------------------------------
$parameters = array(
  "user_auth" => array(
    "user_name" => $username,
    "password" => $password,
    "version" => "1"
  ),
  "application_name" => "RestTest",
  "name_value_list" => array(),
);

$post = array(
  "method" => "login",
  "input_type" => "JSON",
  "response_type" => "JSON",
  "rest_data" => json_encode($parameters)
);

$result = Exec_Curl_request($post, $url);

if ($result->name == "Invalid Login") {
    Return_message(
        "!!!! Error: Login Failed. Did you enter your username"
            . " and password correctly? !!!!"
    );
}

$session_id = $result->id;

/**
Exec_Curl_request
Execute a cURL request

@param string $post fields to setup as CURLOPT_POSTFIELDS
@param string $url  URL to contact with PHP-cURL

@return response of curl request (string)
*/
function Exec_Curl_request($post, $url)
{
    ob_start();
    $curl_request = curl_init($url);

    curl_setopt($curl_request, CURLOPT_POST, 1);
    curl_setopt(
        $curl_request,
        CURLOPT_HTTP_VERSION,
        CURL_HTTP_VERSION_1_0
    );
    curl_setopt($curl_request, CURLOPT_HEADER, 1);
    curl_setopt($curl_request, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl_request, CURLOPT_FOLLOWLOCATION, 0);

    curl_setopt($curl_request, CURLOPT_POSTFIELDS, $post);
    $result = curl_exec($curl_request);
    curl_close($curl_request);

    $result = explode("\r\n\r\n", $result, 2);
    $response = json_decode($result[1]);
    ob_end_flush();

    return $response;
}

/**
Return_message
Spew a docbook-compliant short-form message and terminate script execution

@param string $message message to encapsulate in the docbook embodiment

@return void
*/
function Return_message($message)
{
    echo '<article lang="">';
    echo "<para>$message</para>";
    echo '</article>';
    exit();
}

/**
Return_message
Spew a debugging-oriented message (but don't terminate the script yet)

@param array $parameters array of paramters to json_encode and include in output
@param mixed $result     value that will be print_r()'d for inclusion in output

@return void
*/
function Debug_message($parameters, $result)
{
    echo json_encode($parameters);
    echo "<pre>";
    print_r($result);
    echo "</pre>";
}

/**
Get_project_entry
Get the project entry from SuiteCRM

@param mixed $record_id the record ID of the project entry to request from SuiteCRM

@return array the retrieved project entry json_decode()'d
*/
function Get_Project_entry($record_id)
{
    global $session_id;

    $result = Exec_Curl_request(
        Build_Curl_Request_body(
            'get_entry',
            array(
                "session" => $session_id,
                "module_name" => "Project",
                "id" => $record_id
            )
        ),
        $url
    );

    if ($_GET["debug"] == "1") {
        Debug_message(
            array(
                "session" => $session_id,
                "module_name" => "Project",
                "id" => $record_id
            ),
            $result
        );
    }

    return $result;
}

/**
Get_Project_name
Get project name from a project entry record

@param array $entry the project entry record to get the project name from

@return string the project name
*/
function Get_Project_name($entry)
{
    $return = $entry->entry_list[0]->name_value_list->name->value;
    if ($return <> $_GET["proj_code"]) {
        Return_message(
            "!!!! Project Name " . $_GET["proj_code"]
            . " does not match project name in CRM. Check the CRM Record"
            . " ID entered in the PCS !!!!"
        ); die();
    }
    return $return;
}

/**
Build_Curl_Request_body
Build a PCStoCRM-friendly Curl POST Request body

@param string $method    the SuiteCRM API method we want to call
@param array  $rest_data the REST data to send in the POST request

@return array a request body suitable for use with Exec_Curl_request
*/
function Build_Curl_Request_body($method,$rest_data)
{
    return array(
        "method" => $method,
        "input_type" => "JSON",
        "response_type" => "JSON",
        "rest_data" => json_encode($rest_data),
    );
}

/**
Submit_To_Suitecrm_module
Submit data to a particular SuiteCRM module

@param mixed  $record_id the project entry record ID this submission is tied to
@param string $module    the SuiteCRM module the data should be sent to
@param array  $nResult   the data and parameters to be sent to the module

@return void
*/
function Submit_To_Suitecrm_module($record_id,$module,$nResult)
{
    call_user_func(
        'PCStoCRM_ModulePrep_'.ucfirst($module).'_module',
        $record_id,
        $nResult
    );
}

/**
PCStoCRM_ModulePrep_History_module
Implementation of sending PCS data to the SuiteCRM History module

This function conforms to the following PCStoCRM_ModulePrep_*_module param spec:

@param string $record_id           the project record ID for this module work
@param array  $nResult             the project entry record for this module work
@param string $delivery_module_key the module key prefix for this module call

@return array a request body suitable for use with Exec_Curl_request
*/
function PCStoCRM_ModulePrep_History_module(
    $record_id,
    $nResult,
    $delivery_module_key = "ColDe_"
) {
    global $session_id;

    /* Grab the project values that are set only in CRM and we want to copy into
       Project History */
    $proj_stage = $nResult->entry_list[0]->name_value_list->status->value;
    $proj_type = $nResult->entry_list[0]->name_value_list->project_type_c->value;
    $proj_priority = $nResult->entry_list[0]->name_value_list->priority->value;
    $currency = $nResult->entry_list[0]->name_value_list->currency_id->value;
    // Get the Opportunity and Account values we want to record in Project History
    $parameters = array(
      //session id
      'session' => $session_id,
      //The name of the module from which to retrieve records.
      'module_name' => 'Project',
      //The ID of the specified module bean.
      'module_id' => $_GET["record_id"],
      /* The relationship name of the linked field from which to return records.

         Note: Annoyingly you think this is the relationship field name defined
         in Studio within CRM. However, it seems to be the module name in lower
         case!!! */
      'link_field_name' => 'opportunities',
      /* The portion of the WHERE clause from the SQL statement used to find the
         related items. */
      'related_module_query' => "opportunities.name IS NOT NULL",
      //The related fields to be returned.
      'related_fields' => array(
        'id',
        'name',
        'at_risk_c',
        'po_received_c',
        'po_required_c',
        'msa_c',
        'nda_c'.
        'paying_invoices_rag_c',
        'paying_invoices_com_c'
      ),
      /* For every related bean returned, specify link field names to field
         information. */
      //'related_module_link_name_to_fields_array' => "",
      'related_module_link_name_to_fields_array' => array(
        array(
          'name' => 'accounts',
          'value' => array(
            'id',
            'name',
          ),
        ),
      ),
      //To exclude deleted records
      'deleted'=> 0,
      //order by
      'order_by' => ' opportunities.name ',
      //offset
      'offset' => 0,
      //limit
      'limit' => 200,
    );
    $post = array(
        "method" => "get_relationships",
        "input_type" => "JSON",
        "response_type" => "JSON",
        "rest_data" => json_encode($parameters)
    );
    $result = Exec_Curl_request(
        Build_Curl_Request_body(
            'get_relationships',
            $parameters
        ),
        $url
    );
    if (!array_key_exists('0', $result->entry_list)) {
        Return_message(
            "!!!! ERROR: No Opportunity linked to this project."
                . " Please link one !!!!"
        );
    } elseif (array_key_exists('1', $result->entry_list)) {
        Return_message(
            "!!!! ERROR: More than one Opportunity linked to this"
                . " project. Please ensure project is linked to only one"
                . " opportunity !!!!"
        );
    }
    $opp_id = $result->entry_list[0]->name_value_list->id->value;
    $opp_at_risk = $result->entry_list[0]->name_value_list->at_risk_c->value;
    $opp_po_req = $result->entry_list[0]->name_value_list->po_required_c->value;
    $opp_po_rec = $result->entry_list[0]->name_value_list->po_received_c->value;
    $opp_nda = $result->entry_list[0]->name_value_list->nda_c->value;
    $opp_msa = $result->entry_list[0]->name_value_list->msa_c->value;
    $opp_paying_invoices_rag
        = $result->entry_list[0]->name_value_list->paying_invoices_rag_c->value;
    $opp_paying_invoices_com
        = $result->entry_list[0]->name_value_list->paying_invoices_com_c->value;
    if ($_GET["debug"] == "1") {
        Debug_message($parameters, $result);
    }
    /* Look for an already existing Project History module. Check if a record
       with name set to last Sunday's date exists. If yes, update it, if not,
       create a record and add a relationship to the project. */
    $parameters = array(
      "session" => $session_id,
      "module_name" => $delivery_module_key . "ProjectHistory",
      "query" => "name='"
          . $_GET["proj_code"] . "-" . date('Y-m-d', $last_sunday) . "'",
      "order_by" => '',
      "offset" => 0,
      "select_fields" => array('id', 'name'),
      "link_name_to_fields_array" => "",
      "max_results" => 2,
      "deleted" => 0,
      "favorites" => false
    );
    $post = array(
      "method" => "get_entry_list",
      "input_type" => "JSON",
      "response_type" => "JSON",
      "rest_data" => json_encode($parameters)
    );
    $result = Exec_Curl_request(
        Build_Curl_Request_body(
            'get_entry_list',
            $parameters
        ),
        $url
    );
    if ($_GET["debug"] == "1") {
        Debug_message($parameters, $result);
    }
    //Create array of values to update
    if ($result->result_count > 1) {
        Return_message(
            "!!!! ERROR: There is more than 1 Project History record for week "
                . date('Y-m-d', $last_sunday) . " ! There should be 0 or 1"
                . " only !!!!"
        );
    } elseif ($result->result_count == 1) {
        $first_history = 1;
        // ID of existing Project History record to update
        $to_write = array(
            array(
                "name" => "id",
                "value" => $result->entry_list[0]->id
            )
        );
    } else {
        $first_history = 0;
        // Blank ID as need to create a new record
        $to_write = array(array("name" => "id", "value" => ""));
    }
    //Add in the parameters to write to the Project History record
    foreach ($_GET as $key => $value) {
        if (! in_array($key, $special_params)) {
            array_push($to_write, array("name" => $key, "value" => $value));
        }
    }
    // Add date we are updating CRM with the data
    array_push(
        $to_write,
        array(
            "name" => "pcs_last_updated",
            "value" => $date_now
        )
    );
    /* We use the name field of a Project History record to identify a
       particular weeks snapshot. */
    array_push(
        $to_write,
        array(
            "name" => "name",
            "value" => $_GET["proj_code"] . "-" . date('Y-m-d', $last_sunday)
        )
    );
    //Add in the the values that are set only in CRM
    array_push($to_write, array("name" => "status","value" => $proj_stage));
    array_push($to_write, array("name" => "proj_code","value" => $proj_code));
    array_push(
        $to_write,
        array(
            "name" => "projproj_history_module_nameect_type",
            "value" => $proj_type
        )
    );
    array_push(
        $to_write,
        array(
            "name" => "priority",
            "value" => $proj_priority
        )
    );
    array_push($to_write, array("name" => "currency_id","value" => $currency));
    array_push(
        $to_write,
        array(
            "name" => "opp_at_risk",
            "value" => $opp_at_risk
        )
    );
    array_push(
        $to_write,
        array(
            "name" => "opp_po_received",
            "value" => $opp_po_red
        )
    );
    array_push(
        $to_write,
        array(
            "name" => "opp_po_required",
            "value" => $opp_po_rec
        )
    );
    array_push($to_write, array("name" => "opp_msa","value" => $opp_msa));
    array_push($to_write, array("name" => "opp_nda","value" => $opp_nda));
    array_push(
        $to_write,
        array(
            "name" => "opp_paying_invoices_rag",
            "value" => $opp_paying_invoices_rag
        )
    );
    array_push(
        $to_write,
        array(
            "name" => "opp_paying_invoices_com",
            "value" => $opp_paying_invoices_com
        )
    );
    $parameters = array(
      "session" => $session_id,
      "module_name" => $delivery_module_key . "ProjectHistory",
      "name_value_list" => $to_write
    );
    $post = array(
      "method" => "set_entry",
      "input_type" => "JSON",
      "response_type" => "JSON",
      "rest_data" => json_encode($parameters)
    );
    $result = Exec_Curl_request($post, $url);
    if ($_GET["debug"] == "1") {
        Debug_message($parameters, $result);
    }
    /* If this is a new project history record, we need to associate it to the
       project record */
    if ($first_history == 0) {
        $result = Exec_Curl_request(
            Build_Curl_Request_body(
                'set_relationship',
                array(
                    "session" => $session_id,
                    "module_name" => "Project",
                    "module_id" => $_GET["record_id"],
                    "link_field_name" =>
                      strtolower($delivery_module_key)."projecthistory_project",
                    "name_value_list" => array($result->id),
                    "delete" => "0"
                )
            ),
            $url
        );
        if ($_GET["debug"] == "1") {
            Debug_message(
                array(
                    "session" => $session_id,
                    "module_name" => "Project",
                    "module_id" => $_GET["record_id"],
                    "link_field_name" =>
                      strtolower($delivery_module_key)."projecthistory_project",
                    "name_value_list" => array($result->id),
                    "delete" => "0"
                ),
                $result
            );
        }
    }
}

$default_submission_mode = (isset($_GET['submission_mode'])==false);
if ($default_submission_mode) {
    $result = Get_Project_entry($_GET['record_id']);
    $proj_code = Get_Project_name($result);
    $to_write = array(array("name" => "id", "value" => $_GET["record_id"]));
    foreach ($_GET as $key => $value) {
        if (! in_array($key, $special_params)) {
            array_push($to_write, array("name" => $key, "value" => $value));
        }
    }
    array_push(
        $to_write,
        array(
            "name" => "pcs_last_updated_c",
            "value" => $date_now
        )
    );
    $result = Exec_Curl_request(
        Build_Curl_Request_body(
            'set_entry',
            array(
                "session" => $session_id,
                "module_name" => "Project",
                "name_value_list" => $to_write
            )
        ),
        $url
    );
    if ($_GET["debug"] == "1") {
        Debug_message(
            array(
                "session" => $session_id,
                "module_name" => "Project",
                "name_value_list" => $to_write
            ),
            $result
        );
    }
    Return_message("**** Success! ****");
} else {
    $result = Get_Project_entry($_GET['record_id']);
    $proj_code = Get_Project_name($result);
    //FIXME: remove this static call to history module when implementing others!
    Submit_To_Suitecrm_module($_GET['record_id'],'history',$result);
    Return_message("**** Success! ****");
}
